# Program hunter script

sub find($) {
  # Attempt to locate given program
  my $what = shift;

  my $path = `which $what`;
  if ($path =~ /^which/ |!$path) {
    my @search = `locate $what`;
    map(chomp,@search);
    $path = (grep { print ; /\/$what$/ && -x "$_" } @search)[0];
    if (!$path) {
      $path = `find /bin /usr /opt -path bin -name '$what' -perm o+x -print`;
      chomp($path);
    }
  }
  else { chomp($path); }
  return($path);
}

$__gs = find("gs");
$__pg = find("ppmtogif");
$__gz = defined(find("gzip"));
$__rb = find("R");

# Now write the SystemPrograms module

open(OUT,">Rcgi/SystemPrograms.pm");
select(OUT);
print <<EOF ;
package Rcgi::SystemPrograms;

# Edit these variables to reflect your system configuration

# Some file and directory locations
\$tempdir = "$ENV{TEMPDIR}";
\$Rbinary = "$__rb";
\$imbinary = ""; # Doesn't work as specified yet
\$gsbinary = "$__gs";
\$pgbinary = "$__pg";

\$gzip = $__gz; # 1 for yes, 0 for no

EOF
;

print '
sub conv_to_gif($) {
  # Convert given postscript file to gifs
  # Returns number of pages
  my $name = shift;
  my $output = $name;
  my @pages;

  if ($imbinary) {
    $output =~ s/\.Rps/\.\%02d\.gif/;
    if ($gzip) { $name .= ".gz"; }
    system("$imbinary $name $output");
  }
  else {
    my $cmd;
    $output =~ s/\.Rps/\.\%02d\.ppm/;
    if (! -e $output) {
      if ($gzip) {
	$cmd = "zcat $name.gz |";
      }
      else {
	$cmd = "cat $name |";
      }
      $cmd .= "$gsbinary -sDEVICE=ppmraw -sOutputFile=\"$output\" -sNOPAUSE -q -";
      system($cmd);
      $output =~ s/\.\%02d.ppm/\*\.ppm/;
      $cmd = "for a in $output ; do $pgbinary <\$a >\${a/ppm/gif} ; rm \$a ; done";
      my $junk = `$cmd`;
    }
  }
  opendir(DIR,$tempdir);
  $name =~ s/.*\/(.*?)\.Rps/$1/;
  @pages = grep {/$name.*gif/} readdir(DIR);
  closedir(DIR);
  return(scalar(@pages));
}

1;
';
close(OUT);
