package Rcgi::Session;

use strict;
use IO::File;
use Rcgi::SystemPrograms;

sub new($;$) {
  # Create a new Rcgi session for the user
  # If we're given a session number, then we will use it
  # If not, then we'll make one
  my $this = shift;
  my $class = ref($this) || $this;
  my $request = shift;
  my $self;
  if ((!$request) || (!-e "$Rcgi::SystemPrograms::tempdir/$request.Rout")) {
    $self = $$;
  }
  else {
    $self = $request;
  }
  bless \$self, $class;
  return \$self;
}

sub get_session_id($) {
  # Return the current session id string
  # Use this to future-proof
  my $self = shift;
  return $$self;
}

sub get_text_file($) {
  # Return the current session text output file
  # Use this to future-proof
  my $self = shift;
  return "$Rcgi::SystemPrograms::tempdir/".($self->get_session_id()).".Rout";
}

sub get_gif_file($) {
  # Return the current session text output file
  # Use this to future-proof
  my $self = shift;
  my $page = shift;
  return "$Rcgi::SystemPrograms::tempdir/".($self->get_session_id()).sprintf(".%02d",$page).".gif";
}

sub get_ps_file($) {
  # Return the current session postscript file
  # Use this to future-proof
  my $self = shift;
  return "$Rcgi::SystemPrograms::tempdir/".($self->get_session_id()).".Rps";
}

sub execute($$) {
  # Pass an R script to an R interpreter
  my $self = shift;
  my $in = shift;

  my $sesh = $self->get_session_id;
  my $Rbin = $Rcgi::SystemPrograms::Rbinary;
  chdir($Rcgi::SystemPrograms::tempdir);

  open(R, "| tee $sesh.Rin | $Rbin --no-save >".($self->get_text_file()));
  print R "postscript(\"".($self->get_ps_file())."\")\n";
  $in =~ s/\r//g;
  $in =~ s/(unlink|postscript|system)[^\n]*//g;
  # I think they're the only really nasty things to trap...
  print R $in."\n"; # End it politely (not an EOF at the end of a command)
  close R;

  if ($Rcgi::SystemPrograms::gzip) { system("gzip ".($self->get_ps_file())); }

}

sub render($) {
  # Convert the graphical output to gifs
  # Return number of pages
  my $self = shift;
  return (Rcgi::SystemPrograms::conv_to_gif($self->get_ps_file()));
}

### The following all return objects of type IO::File

sub text($) {
  # Return the textual output for this session id
  my $self = shift;

  return (new IO::File "< ".($self->get_text_file()));
}

sub gif($$) {
  # Return the graphical output for this session and page
  my $self = shift;
  my $page = shift;
  return (new IO::File "< ".($self->get_gif_file($page)));
}

#sub png($$) {
#  # Return the graphical output for this session and page
#  my $self = shift;
#
#  return (new IO::File "< ".($self->get_text_file()));
#}

sub postscript($) {
  # Return the graphical output for this session
  my $self = shift;

  my $file = $self->get_ps_file();
  if ($Rcgi::SystemPrograms::gzip) { system("gzip -d $file.gz"); }
  return (new IO::File "< $file");

}

sub DESTROY {
  my $self = shift;
  if ($Rcgi::SystemPrograms::gzip && -e ($self->get_ps_file())) {
    system("gzip ".($self->get_ps_file())." >/dev/null 2>&1");
  }
}
1;
