package Rcgi::SystemPrograms;

# Edit these variables to reflect your system configuration

# Some file and directory locations
$tempdir = "/tmp";
$Rbinary = "/usr/local/bin/R";
$imbinary = ""; #/usr/X11R6/bin/convert";  # Doesn't work as specified
$gsbinary = "/usr/bin/gs";
$pgbinary = "/usr/bin/ppmtogif";

$gzip = 1; # 1 for yes, 0 for no

sub conv_to_gif($) {
  # Convert given postscript file to gifs
  # Returns number of pages
  my $name = shift;
  my $output = $name;
  my @pages;

  if ($imbinary) {
    $output =~ s/\.Rps/\.\%02d\.gif/;
    if ($gzip) { $name .= ".gz"; }
    system("$imbinary $name $output");
  }
  else {
    my $cmd;
    $output =~ s/\.Rps/\.\%02d\.ppm/;
    if ($gzip) {
      $cmd = "zcat $name.gz |";
    }
    else {
      $cmd = "cat $name |";
    }
    $cmd .= "$gsbinary -sDEVICE=ppmraw -sOutputFile=\"$output\" -sNOPAUSE -q -";
    system($cmd);
    $output =~ s/\.\%02d.ppm/\*\.ppm/;
    $cmd = "for a in $output ; do $pgbinary <\$a >\${a/ppm/gif} ; rm \$a ; done";
    my $junk = `$cmd`;
  }
  opendir(DIR,$tempdir);
  $name =~ s/.*\/(.*?)\.Rps/$1/;
  @pages = grep {/$name.*gif/} readdir(DIR);
  closedir(DIR);
  return(scalar(@pages));
}

1;

